package com.microcontrollerbg.irdroid_light;
import android.app.Activity;
import android.app.ActivityGroup;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.res.Resources;
import android.hardware.Sensor;
import android.hardware.SensorManager;

import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Vibrator;
import android.preference.PreferenceManager;
import android.text.method.LinkMovementMethod;
import android.util.Log;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.WindowManager;

import android.widget.TabHost.*;
import android.widget.TabHost;
import android.widget.TextView;
import android.widget.Toast;
import android.widget.ToggleButton;

public class Irdroid_light extends ActivityGroup  {
	private static final String TAG = "AudioDemo";
	private static final String isPlaying = "Media is Playing"; 
	private static final String notPlaying = "Media has stopped Playing"; 
	 private SensorManager mSensorManager;
		private AudioManager audio;
	  private ShakeEventListener mSensorListener;
	  TabHost 
		tabs;
int shaked = 1;
SharedPreferences mPrefs;
ToggleButton onOffButton;
	MediaPlayer player;
//	Button playerButton;
	SharedPreferences sharedPrefs;
	MediaPlayer player2;
	private Vibrator myVib;
	private int About = Menu.FIRST;
	private int Settings;
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		
		super.onCreate(savedInstanceState);
		sharedPrefs = PreferenceManager.getDefaultSharedPreferences(this);

	//	StringBuilder builder = new StringBuilder();
		 firstRunPreferences();
		 if(getFirstRun()){
	        	About();
	        	setRunned();
	        	
	        }
		int now = getVolume();
		setContentView(R.layout.main);
		
		audio = (AudioManager) getSystemService(Context.AUDIO_SERVICE);
		audio.setStreamVolume(AudioManager.STREAM_MUSIC,now, 0);
        
    	
		
	
		tabs = (TabHost) this.findViewById(R.id.my_tabhost);
		  Resources res = getResources();
		//tabs.clearAllTabs();
		myVib = (Vibrator) this.getSystemService(VIBRATOR_SERVICE);
		tabs.setup(this.getLocalActivityManager());

		
		
		TabSpec tspec1 = tabs.newTabSpec("content");
		tspec1.setIndicator("Control", res.getDrawable(R.drawable.control));
		tspec1.setContent(R.id.content);
		tabs.addTab(tspec1);
		//TabSpec tspec2 = tabs.newTabSpec("Second Tab");
		//tspec2.setIndicator("Colors");
		//tspec2.setContent(R.id.content);
		//tabs.addTab(tspec2);
		TabSpec tspec3 = tabs.newTabSpec("Effects");
		tspec3.setIndicator("Effects", res.getDrawable(R.drawable.tab_colors));
		//.setIndicator("Artists", res.getDrawable(R.drawable.tab_colors));
               
		tspec3.setContent(new Intent(this, CitiesActivity.class));
		tabs.addTab(tspec3);
		
		
		Integer lastTab = (Integer) getLastNonConfigurationInstance();
		   if(lastTab != null) {
		      tabs.setCurrentTab(lastTab);
		     
		   } else {
			   
			   tabs.setCurrentTab(0);  
		   }

			
			
		
		
		
		
	
		
		onOffButton=(ToggleButton)findViewById(
		        R.id.widget36);
       
       
      
      
     

    	   
       

		
		player = MediaPlayer.create(this, R.raw.robotrack);
		player.setLooping(false); // Set looping
		player2 = MediaPlayer.create(this, R.raw.off);
		player2.setLooping(false); 
//player.start();
		// Get the button from the view

	if(sharedPrefs.getBoolean("shake_trigger", false)){
		mSensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
		    mSensorListener = new ShakeEventListener();   

		    mSensorListener.setOnShakeListener(new ShakeEventListener.OnShakeListener() {
		    
		      public void onShake() {
		       // Toast.makeText(Irdroid_light.this, "Shake!", Toast.LENGTH_SHORT).show();
		       myVib.vibrate(50);
		        
		        if (shaked == 1){
		        	Toast.makeText(Irdroid_light.this, "On!", Toast.LENGTH_SHORT).show();
		        	shaked = 2;
		        	demoPlay();
		        //	onOffButton.setChecked(true);
		        }
		        else if (shaked == 2){
		        	Toast.makeText(Irdroid_light.this, "Off!", Toast.LENGTH_SHORT).show();
		        	shaked = 1;
		        	player2.start();
		        	//onOffButton.setChecked(false);
		        }
		     
		      }
		    });

	}
		    ToggleButton.OnClickListener tbListener =
		        new ToggleButton.OnClickListener() {
		      @Override
		      public void onClick(View v) {
		        if (onOffButton.isChecked()) {
		          onOffButton.setBackgroundResource(R.drawable.on);
		          demoPlay();
		          if(sharedPrefs.getBoolean("heptic_feedback", false)){
		        	  myVib.vibrate(50); 
		          }
		          
		        

		          savePreferences("toggleBut", onOffButton.isChecked());

		          //player.release();
		        } else {
		        	 savePreferences("toggleBut", onOffButton.isChecked());
		        	 onOffButton.setBackgroundResource(R.drawable.off);
		        	// demoPause();
		        	 player2.start();
		        	 if(sharedPrefs.getBoolean("heptic_feedback", false)){
			        	  myVib.vibrate(50); 
			          }
		        	

			         
		        }
		      }
		    };
		
		    onOffButton.setOnClickListener(tbListener);
		      

	
		
	}
	
	  /**

     * setting up preferences storage

     */
	 public int getVolume() {
    	 return mPrefs.getInt("volume", 50);	 
     }
     public void firstRunPreferences() {

        Context mContext = this.getApplicationContext();

        mPrefs = mContext.getSharedPreferences("myAppPrefs", 0); //0 = mode private. only this app can read these preferences

     }
     public boolean getFirstRun() {
    	 
         return mPrefs.getBoolean("firstRun", true);
  
      }
     
     public String About(){
    	 
     	AlertDialog.Builder about = new AlertDialog.Builder(this);
         about.setTitle(R.string.app_name)
               //  .setIcon(R.drawable.dialog_icon)
                .setMessage(R.string.info)
                .setCancelable(true)
                .setNegativeButton("Dismiss", new DialogInterface.OnClickListener() {
                   public void onClick(DialogInterface dialog, int id) {
                         dialog.dismiss();
                    }
               });

         AlertDialog welcomeAlert = about.create();
         welcomeAlert.show();
    //      Make the textview clickable. Must be called after show()
         ((TextView)welcomeAlert.findViewById(android.R.id.message)).setMovementMethod(LinkMovementMethod.getInstance());
 return null;
 	
     }
     public void setRunned() {

         SharedPreferences.Editor edit = mPrefs.edit();

         edit.putBoolean("firstRun", false);

         edit.commit();

      }
     
     public void setVolume(int volume){
    		
    		SharedPreferences.Editor edit = mPrefs.edit();
    		edit.putInt("volume", volume);
    		edit.commit();
    	}

    
	public boolean onOptionsItemSelected(MenuItem item) {

		if (item.getTitle()== "About"){
			
			
			 About();
			
		//    addPreferencesFromResource(R.xml.preferences);      
			return true;
    	
        	     
                 
    	}else if (item.getTitle()== "Settings")
    	{
    		startActivity(new Intent(this, QuickPrefsActivity.class));
    		return true;
    	}

		return false;
		}
	private void addPreferencesFromResource(int preferences) {
		// TODO Auto-generated method stub
		
	}

	public boolean onCreateOptionsMenu(Menu menu) {
		super.onCreateOptionsMenu(menu);

		menu.add(0, About, 0, "About").setIcon(android.R.drawable.ic_menu_info_details);   ;
		menu.add(0, Settings, 0, "Settings").setIcon(android.R.drawable.ic_menu_preferences);
		return true;
		}
	
	  
	
	@Override
	public void onPause() {
		super.onPause();
	//	player.pause();
		 if(sharedPrefs.getBoolean("shake_trigger", false)){
		mSensorManager.unregisterListener(mSensorListener);
		 }
		  

	}

	// Initiate media player pause
	public Object onRetainNonConfigurationInstance() {
	    return tabs.getCurrentTab();
	  
	}
	


	private void demoPause(){
	    player.pause();
	   // playerButton.setText(R.string.play_label);
	    Toast.makeText(this, notPlaying, Toast.LENGTH_LONG).show();
	    Log.d(TAG, notPlaying);
		}
	// Initiate playing the media player
	private void demoPlay(){
    player.start();
   // playerButton.setText(R.string.stop_label);
 //   Toast.makeText(this, isPlaying, Toast.LENGTH_LONG).show();
  //  Log.d(TAG, isPlaying);
	}
	private void savePreferences(String key, boolean value){
        SharedPreferences sharedPreferences = getPreferences(MODE_PRIVATE);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(key, value);
        editor.commit();
    }
	
	   public boolean onKeyDown(int keyCode, KeyEvent event) {
	        switch (keyCode) {
	    	    case KeyEvent.KEYCODE_VOLUME_UP:
	    	        audio.adjustStreamVolume(AudioManager.STREAM_MUSIC,
	    	                AudioManager.ADJUST_RAISE, AudioManager.FLAG_SHOW_UI);
	    	        int volume =  audio.getStreamVolume(AudioManager.STREAM_MUSIC);
	    	      setVolume(volume);
	    	        return true;
	    	    case KeyEvent.KEYCODE_VOLUME_DOWN:
	    	        audio.adjustStreamVolume(AudioManager.STREAM_MUSIC,
	    	                AudioManager.ADJUST_LOWER, AudioManager.FLAG_SHOW_UI);
	    	        int volume_dn =  audio.getStreamVolume(AudioManager.STREAM_MUSIC);
	      	      setVolume(volume_dn);
	    	        return true;
	    	    case KeyEvent.KEYCODE_BACK:
	    	    	finish();
	    	    	return true;
	    	        
	    	    default:
	    	    	super.onKeyDown(keyCode, event);
	//return true;
	    	    	return false;
	    	    }
	    	}

    private boolean loadPreferences(String key){
        SharedPreferences sharedPreferences = getPreferences(MODE_PRIVATE);
        return sharedPreferences.getBoolean(key, true);
    }

    protected void onDestroy(){
   	 super.onDestroy();
   	
   	    }
    
    
    protected void onStop(){
    	super.onStop();
    	
    	
    }
    
    
	protected void onResume() {
	    super.onResume();
	    if (sharedPrefs.getBoolean("fix_orientation_to_portrait", false)) {
	        this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
	    } else {
	        this.setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_SENSOR);
	    }

	    if(sharedPrefs.getBoolean("shake_trigger", false)){
	    	   if (mSensorListener==null){
	    		   
	    		   
		    	    mSensorManager = (SensorManager) getSystemService(Context.SENSOR_SERVICE);
				    mSensorListener = new ShakeEventListener();   

				    mSensorListener.setOnShakeListener(new ShakeEventListener.OnShakeListener() {
				    
				      public void onShake() {
				       // Toast.makeText(Irdroid_light.this, "Shake!", Toast.LENGTH_SHORT).show();
				       myVib.vibrate(50);
				        
				        if (shaked == 1){
				        	Toast.makeText(Irdroid_light.this, "On!", Toast.LENGTH_SHORT).show();
				        	shaked = 2;
				        	demoPlay();
				        //	onOffButton.setChecked(true);
				        }
				        else if (shaked == 2){
				        	Toast.makeText(Irdroid_light.this, "Off!", Toast.LENGTH_SHORT).show();
				        	shaked = 1;
				        	player2.start();
				        	//onOffButton.setChecked(false);
				        }
				     
				      }
				    });

	    		   
	    		   
	    		   
	    		  
	    	   } else {
	    		   
	    		   mSensorManager.registerListener(mSensorListener,
	    				   mSensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER),
	    			        SensorManager.SENSOR_DELAY_UI);
	    	   }
	        
	    	    
	    	   
	    	    
	    	    
	    }
	    boolean saved = loadPreferences("toggleBut");
	       
	       if (saved = true){
	    	   onOffButton.setBackgroundResource(R.drawable.on); 
	    	   onOffButton.setChecked(saved);
	       }
	       else if (saved=false) {
	    	   onOffButton.setBackgroundResource(R.drawable.off); 
	    	   onOffButton.setChecked(saved);
	       }

	  }


	
}